/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.debuffs;

import dev.toma.gunsrpg.api.common.attribute.IAttributeProvider;
import dev.toma.gunsrpg.api.common.data.IDebuffs;
import dev.toma.gunsrpg.api.common.data.IPlayerData;
import dev.toma.gunsrpg.common.capability.PlayerData;
import dev.toma.gunsrpg.common.debuffs.DataDrivenDebuffType;
import dev.toma.gunsrpg.common.debuffs.IDebuffType;
import dev.toma.gunsrpg.common.debuffs.IStagedDebuff;
import dev.toma.gunsrpg.common.debuffs.ProgressingDebuff;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;

public class StagedDebuff
implements IStagedDebuff,
ProgressingDebuff {
    private final DataDrivenDebuffType<?> type;
    private int stage;
    private int progression;
    private int progressionCounter;
    private int ticksSinceAdded;
    private int ticksSinceProgressed;
    private int ticksSinceHealed;
    private boolean frozen;

    public StagedDebuff(DataDrivenDebuffType<?> type) {
        this.type = type;
        this.stage = 0;
        this.ticksSinceHealed = 100;
    }

    @Override
    public void tick(PlayerEntity player) {
        PlayerData.get(player).ifPresent(data -> {
            this.updateRenderCounters();
            int delay = this.type.getDelay((IPlayerData)data);
            if (this.canSpread() && ++this.progressionCounter >= delay) {
                this.incrementProgression(1);
                if (!player.field_70170_p.field_72995_K) {
                    data.sync(8);
                }
            }
            if (!this.isFrozen(data.getAttributes())) {
                DataDrivenDebuffType.DebuffStage debuffStage = this.type.getStage(this.stage);
                debuffStage.apply(player);
            }
        });
    }

    @Override
    public void incrementProgression(int count) {
        int prevProgression = this.progression;
        this.progression = Math.min(this.getProgressionLimit(), this.progression + count);
        if (prevProgression != this.progression) {
            this.progressionCounter = 0;
            this.ticksSinceProgressed = 0;
            this.updateStage();
        }
    }

    @Override
    public float getBlockingProgress(IAttributeProvider provider) {
        return DataDrivenDebuffType.getBuffedProgress(provider, this.type.getBlockingAttribute());
    }

    @Override
    public boolean isFrozen(IAttributeProvider attributes) {
        return this.type.isDisabledByAttributes(attributes);
    }

    @Override
    public void heal(int amount, IDebuffs data) {
        if ((this.progression -= amount) < 0) {
            data.clearDebuff(this.type);
        }
        this.ticksSinceHealed = 0;
    }

    @Override
    public int getCurrentProgress() {
        return this.progression;
    }

    @Override
    public IDebuffType<?> getType() {
        return this.type;
    }

    @Override
    public boolean canSpread() {
        return this.progression < 100;
    }

    @Override
    public int ticksSinceAdded() {
        return this.ticksSinceAdded;
    }

    @Override
    public int ticksSinceHealed() {
        return this.ticksSinceHealed;
    }

    @Override
    public int ticksSinceProgressed() {
        return this.ticksSinceProgressed;
    }

    protected int getProgressionLimit() {
        return 100;
    }

    @Override
    public CompoundNBT toNbt() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74768_a("progression", this.progression);
        nbt.func_74768_a("progressionCounter", this.progressionCounter);
        this.saveNonZeroInt(nbt, this.ticksSinceAdded, "ticksSinceAdded");
        this.saveNonZeroInt(nbt, this.ticksSinceProgressed, "ticksSinceProgressed");
        this.saveNonZeroInt(nbt, this.ticksSinceHealed, "ticksSinceHealed");
        return nbt;
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        this.progression = nbt.func_74762_e("progression");
        this.progressionCounter = nbt.func_74762_e("progressionCounter");
        this.ticksSinceAdded = nbt.func_74762_e("ticksSinceAdded");
        this.ticksSinceProgressed = nbt.func_74762_e("ticksSinceProgressed");
        this.ticksSinceHealed = nbt.func_74762_e("ticksSinceHealed");
        this.updateStage();
    }

    @Override
    public boolean shouldRemove() {
        return this.progression < 0;
    }

    private void updateStage() {
        int stageIndex = 0;
        if (this.type.getStages() == null) {
            this.stage = stageIndex;
            return;
        }
        int i = 0;
        while (i < this.type.getStages().size()) {
            DataDrivenDebuffType.DebuffStage testStage = this.type.getStage(i);
            stageIndex = i++;
            if (testStage.isApplicable(this.progression)) break;
        }
        this.stage = stageIndex;
    }

    private void updateRenderCounters() {
        ++this.ticksSinceAdded;
        ++this.ticksSinceProgressed;
        ++this.ticksSinceHealed;
    }

    private void saveNonZeroInt(CompoundNBT nbt, int value, String name) {
        if (value != 0) {
            nbt.func_74768_a(name, value);
        }
    }
}

